﻿//////////////////////////////////////////////
// VectorWrapper.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class Environment ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

// nkScripts
#include <NilkinsScripts/Environments/Functions/Function.h>

/// Class ------------------------------------

namespace nkAstraeus::nkMathsWrap
{
	class DLL_ASTRAEUS_EXPORT VectorWrapper final
	{
		public :

			// Environment update
			static void updateEnvironment (nkScripts::Environment* env) ;

			// Callbacks
			// Construction / destruction
			static void* constructor (const nkScripts::DataStack& stack) ;
			static void destructor (void* toDestroy) ;
			static nkScripts::OutputValue newVec2 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue newVec3 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue newVec4 (const nkScripts::DataStack& stack) ;
			// Getters
			static nkScripts::OutputValue getX (void* vector) ;
			static nkScripts::OutputValue getY (void* vector) ;
			static nkScripts::OutputValue getZ (void* vector) ;
			static nkScripts::OutputValue getW (void* vector) ;
			// Setters
			static void setX (const nkScripts::DataStack& stack) ;
			static void setY (const nkScripts::DataStack& stack) ;
			static void setZ (const nkScripts::DataStack& stack) ;
			static void setW (const nkScripts::DataStack& stack) ;
			// Length
			static nkScripts::OutputValue getLengthVec2 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getLengthVec3 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getLengthVec4 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getLengthSquaredVec2 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getLengthSquaredVec3 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getLengthSquaredVec4 (const nkScripts::DataStack& stack) ;
			// Distance
			static nkScripts::OutputValue getDistanceVec2 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getDistanceVec3 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getDistanceVec4 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getDistanceSquaredVec2 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getDistanceSquaredVec3 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getDistanceSquaredVec4 (const nkScripts::DataStack& stack) ;
			// Normalization
			static nkScripts::OutputValue normalizeVec2 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue normalizeVec3 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue normalizeVec4 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getNormalizedVec2 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getNormalizedVec3 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getNormalizedVec4 (const nkScripts::DataStack& stack) ;
			// Dot product
			static nkScripts::OutputValue dotProductVec2 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue dotProductVec3 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue dotProductVec4 (const nkScripts::DataStack& stack) ;
			// Cross product
			static nkScripts::OutputValue setAsCrossVec3 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getCrossVec3 (const nkScripts::DataStack& stack) ;
			// Conversion
			static nkScripts::OutputValue toString (const nkScripts::DataStack& stack) ;
			// Operators
			static nkScripts::OutputValue add (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue sub (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue mul (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue div (const nkScripts::DataStack& stack) ;
			// Logical
			static nkScripts::OutputValue eq (const nkScripts::DataStack& stack) ;

			// Static versions
			// Distance
			static nkScripts::OutputValue distanceVec2 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue distanceVec3 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue distanceVec4 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue distanceSquaredVec2 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue distanceSquaredVec3 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue distanceSquaredVec4 (const nkScripts::DataStack& stack) ;
			// Dot product
			static nkScripts::OutputValue dotVec2 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue dotVec3 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue dotVec4 (const nkScripts::DataStack& stack) ;
			// Cross product
			static nkScripts::OutputValue crossVec3 (const nkScripts::DataStack& stack) ;
	} ;
}